#ifndef __gui__ui_utils_h
#define __gui__ui_utils_h

#include <QFrame>
#include <QLabel>
#include <QPlainTextEdit>
#include <QSize>
#include <QString>
#include <QWidget>

namespace TextWidgets {

class Header : public QWidget {
		Q_OBJECT

	public:
		Header(QString title, QWidget* parent = nullptr);
		void SetText(QString title);

	private:
		QLabel* static_text_title;
		QFrame* static_text_line;
};

class Paragraph : public QPlainTextEdit {
		Q_OBJECT

	public:
		Paragraph(QString text, QWidget* parent = nullptr);
		void SetText(QString text);
		QSize minimumSizeHint() const override;
		QSize sizeHint() const override;
};

/* technically a paragraph and a heading is actually a
   "section", but that name is equally as confusing as
   "text paragraph". */
class TextParagraph : public QWidget {
		Q_OBJECT

	public:
		TextParagraph(QString title, QString data, QWidget* parent = nullptr);
		Header* GetHeader();
		Paragraph* GetParagraph();

	private:
		Header* header;
		Paragraph* paragraph;
};

class LabelledTextParagraph : public QWidget {
		Q_OBJECT

	public:
		LabelledTextParagraph(QString title, QString label, QString data, QWidget* parent = nullptr);
		Header* GetHeader();
		Paragraph* GetLabels();
		Paragraph* GetParagraph();

	private:
		Header* header;
		Paragraph* labels;
		Paragraph* paragraph;
};

class SelectableTextParagraph : public QWidget {
		Q_OBJECT

	public:
		SelectableTextParagraph(QString title, QString data, QWidget* parent = nullptr);
		Header* GetHeader();
		Paragraph* GetParagraph();

	private:
		Header* header;
		Paragraph* paragraph;
};

class Title : public Paragraph {
		Q_OBJECT

	public:
		Title(QString title, QWidget* parent = nullptr);
};

} // namespace TextWidgets

#endif // __gui__ui_utils_h
