#include "gui/dialog/settings.h"
#include "gui/widgets/sidebar.h"
#include "gui/widgets/text.h"
#include <QDialogButtonBox>
#include <QStackedWidget>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QWidget>

SettingsPage::SettingsPage(QWidget* parent, QString title) : QWidget(parent) {
	setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	page_title = new QLabel(title, this);
	page_title->setWordWrap(false);
	page_title->setFrameShape(QFrame::Panel);
	page_title->setFrameShadow(QFrame::Sunken);

	QFont font(page_title->font());
	font.setPointSize(10);
	font.setWeight(QFont::Bold);
	page_title->setFont(font);

	QPalette pal = page_title->palette();
	pal.setColor(QPalette::Window, QColor(0xAB, 0xAB, 0xAB));
	pal.setColor(QPalette::WindowText, Qt::white);
	page_title->setPalette(pal);
	page_title->setAutoFillBackground(true);

	page_title->setFixedHeight(23);
	page_title->setAlignment(Qt::AlignVCenter | Qt::AlignLeft);
	page_title->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed);

	tab_widget = new QTabWidget(this);
	tab_widget->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);

	QVBoxLayout* layout = new QVBoxLayout(this);
	layout->setContentsMargins(0, 0, 0, 0);
	layout->addWidget(page_title);
	layout->addWidget(tab_widget);
}

void SettingsPage::SetTitle(QString title) {
	page_title->setText(title);
}

void SettingsPage::AddTab(QWidget* tab, QString title) {
	tab_widget->addTab(tab, title);
}

void SettingsPage::SaveInfo() {
	// no-op... child classes will implement this
}

void SettingsDialog::OnOK() {
	QStackedWidget* stacked = reinterpret_cast<QStackedWidget*>(layout()->itemAt(1)->widget());
	for (int i = 0; i < stacked->count(); i++) {
		reinterpret_cast<SettingsPage*>(stacked->widget(i))->SaveInfo();
	}
	QDialog::accept();
}

SettingsDialog::SettingsDialog(QWidget* parent) : QDialog(parent) {
	setFixedSize(755, 566);
	setWindowTitle(tr("Settings"));
	setWindowFlags(Qt::Dialog | Qt::CustomizeWindowHint | Qt::WindowTitleHint | Qt::WindowCloseButtonHint);
	QWidget* widget = new QWidget(this);
	widget->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	sidebar = new SideBar(widget);
	sidebar->setCurrentItem(sidebar->AddItem(tr("Services"), SideBar::CreateIcon(":/icons/24x24/globe.png")));
	// sidebar->AddItem(tr("Library"), SideBar::CreateIcon(":/icons/24x24/inbox-film.png"));
	sidebar->AddItem(tr("Application"), SideBar::CreateIcon(":/icons/24x24/application-sidebar-list.png"));
	// sidebar->AddItem(tr("Recognition"), SideBar::CreateIcon(":/icons/24x24/question.png"));
	// sidebar->AddItem(tr("Sharing"), SideBar::CreateIcon(":/icons/24x24/megaphone.png"));
	// sidebar->AddItem(tr("Torrents"), SideBar::CreateIcon(":/icons/24x24/feed.png"));
	// sidebar->AddItem(tr("Advanced"), SideBar::CreateIcon(":/icons/24x24/gear.png"));
	sidebar->setIconSize(QSize(24, 24));
	sidebar->setFrameShape(QFrame::Box);

	QFont font(sidebar->font());
	font.setPointSize(9);
	sidebar->setFont(font);

	QPalette pal(sidebar->palette());
	pal.setColor(QPalette::Base, pal.color(QPalette::Window));
	sidebar->setPalette(pal);

	sidebar->setFixedWidth(158);
	sidebar->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Expanding);

	QStackedWidget* stacked = new QStackedWidget(this);
	stacked->addWidget(new SettingsPageServices(stacked));
	stacked->addWidget(new SettingsPageApplication(stacked));
	stacked->setCurrentIndex(0);

	connect(sidebar, &QListWidget::currentRowChanged, stacked, &QStackedWidget::setCurrentIndex);

	QHBoxLayout* layout = new QHBoxLayout(widget);
	layout->addWidget(sidebar);
	layout->addWidget(stacked);
	layout->setContentsMargins(0, 0, 0, 0);

	QDialogButtonBox* button_box = new QDialogButtonBox(QDialogButtonBox::Ok | QDialogButtonBox::Cancel, this);
	connect(button_box, &QDialogButtonBox::accepted, this, &SettingsDialog::OnOK);
	connect(button_box, &QDialogButtonBox::rejected, this, &QDialog::reject);

	QVBoxLayout* buttons_layout = new QVBoxLayout(this);
	buttons_layout->addWidget(widget);
	buttons_layout->addWidget(button_box);
}

#include "gui/dialog/moc_settings.cpp"
