#include "sys/win32/dark_theme.h"
#include <QOperatingSystemVersion>
#include <QSettings>

namespace win32 {

bool DarkThemeAvailable() {
	// dark mode supported Windows 10 1809 10.0.17763 onward
	// https://stackoverflow.com/questions/53501268/win10-dark-theme-how-to-use-in-winapi
	const auto& ver = QOperatingSystemVersion::current();
	return (ver.majorVersion() > 10) ? true : (ver.majorVersion() == 10 && ver.microVersion() >= 17763);
}

bool IsInDarkTheme() {
	QSettings settings("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize",
	                   QSettings::NativeFormat);
	return settings.value("AppsUseLightTheme", 1).toInt() == 0;
}

} // namespace win32
