#ifndef __core__torrent_h
#define __core__torrent_h

#include <string>
#include <QDateTime>

/* this will be moved into its own namespace if
   it's deemed necessary */
class Torrent {
	public:
		std::string GetTitle() const { return _title; };
		std::string GetEpisode() const { return _episode; };
		std::string GetGroup() const { return _group; };
		size_t GetSize() const { return _size; };
		std::string GetResolution() const { return _resolution; };
		int GetSeeders() const { return _seeders; };
		int GetLeechers() const { return _leechers; };
		int GetDownloaders() const { return _downloaders; };
		std::string GetDescription() const { return _description; };
		std::string GetFilename() const { return _filename; };
		std::string GetLink() const { return _link; };
		std::string GetGuid() const { return _guid; };
		QDateTime GetDate() const { return _date; };

		void SetTitle(const std::string& title) { _title = title; };
		void SetEpisode(const std::string& episode) { _episode = episode; };
		void SetGroup(const std::string& group) { _group = group; };
		void SetSize(const size_t size) { _size = size; };
		void SetResolution(const std::string& resolution) { _resolution = resolution; };
		void SetSeeders(const int seeders) { _seeders = seeders; };
		void SetLeechers(const int leechers) { _leechers = leechers; };
		void SetDownloaders(const int downloaders) { _downloaders = downloaders; };
		void SetDescription(const std::string& description) { _description = description; };
		void SetFilename(const std::string& filename) { _filename = filename; };
		void SetLink(const std::string& link) { _link = link; };
		void SetGuid(const std::string& guid) { _guid = guid; };
		void SetDate(const QDateTime& date) { _date = date; };

	private:
		std::string _title;
		std::string _episode;
		std::string _group;
		size_t _size = 0;
		std::string _resolution; /* technically should be an int,
		                            but std::string is more useful */
		int _seeders = 0;
		int _leechers = 0;
		int _downloaders = 0;
		std::string _description;
		std::string _filename;
		std::string _link;
		std::string _guid;
		QDateTime _date;
};

#endif // __core__torrent_h