#include <string>
#include <vector>

#include <windows.h>

#include "animia.h"
#include "animia/util.h"
#include "animia/strategies.h"
#ifdef ANIMIA_ON_WIN32
#include "animia/fd/win32.h"
#endif
#include <iostream>

namespace animia {

static bool ProcessInPlayers(const std::vector<Player>& players, const std::string& name, Player& player_) {
	for (const auto& player : players) {
		for (const auto& exe : player.executables) {
			if (exe == name.substr(0, name.rfind(".exe"))) {
				player_ = player;
				return true;
			}
		}
	}
	return false;
}

bool GetResults(const std::vector<Player>& players, std::vector<Result>& results) {
	std::set<pid_t> pids;

#ifdef ANIMIA_ON_WIN32
	/* todo: make these functions also return process names in a tuple,
	   cause the win32 api gives it to us for free! */
	if (!internal::win32::GetAllPids(pids))
#elif ANIMIA_ON_LINUX
	if (!internal::linux::GetAllPids(pids))
#elif ANIMIA_ON_UNIX
	if (!internal::unix::GetAllPids(pids))
#endif
		return false;

	for (const auto& pid : pids) {
		std::string name;
#ifdef ANIMIA_ON_WIN32
		animia::internal::win32::GetProcessName(pid, name);
#endif

		Player player;
		if (!ProcessInPlayers(players, name, player))
			continue;

		Result result;
		result.process.pid = pid;
		result.process.name = name;
		result.player = player;
		results.push_back(result);
	}

	return internal::ApplyStrategies(results);
}

}