#ifndef __animia__animia__fd__linux_h
#define __animia__animia__fd__linux_h

#include <vector>
#include <tuple>
#include <string>
#include <set>

#include <sys/types.h> // pid_t

namespace animia::internal::linux {

bool GetAllPids(std::set<pid_t>& pids);
bool GetProcessName(pid_t pid, std::string& result);
bool EnumerateOpenFiles(const std::set<pid_t>& pids, std::vector<std::tuple<pid_t, std::string>>& files);

}

#endif // __animia__animia__fd__linux_h