/**
 * config.cpp:
 * parses the config... lol
 **/
#include "core/config.h"
#include "core/anime.h"
#include "core/filesystem.h"
#include "core/json.h"
#include "gui/translate/anime.h"
#include "gui/translate/config.h"
#include <cstdlib>
#include <cstring>
#include <filesystem>
#include <fstream>
#include <limits.h>

int Config::Load() {
	Filesystem::Path cfg_path = Filesystem::GetConfigPath();
	if (!cfg_path.Exists())
		return 0;
	std::ifstream config(cfg_path.GetPath(), std::ifstream::in);
	auto config_js = nlohmann::json::parse(config);
	service = Translate::ToService(JSON::GetString(config_js, "/General/Service"_json_pointer, "None"));
	anime_list.language = Translate::ToLanguage(JSON::GetString(config_js, "/Anime List/Title language"_json_pointer, "Romaji"));
	anime_list.display_aired_episodes = JSON::GetBoolean(config_js, "/Anime List/Display only aired episodes"_json_pointer, true);
	anime_list.display_available_episodes = JSON::GetBoolean(config_js, "/Anime List/Display only available episodes in library"_json_pointer, true);
	anime_list.highlight_anime_if_available = JSON::GetBoolean(config_js, "/Anime List/Highlight anime if available"_json_pointer, true);
	anime_list.highlighted_anime_above_others = JSON::GetBoolean(config_js, "/Anime List/Display highlighted anime above others"_json_pointer);
	anilist.auth_token = JSON::GetString(config_js, "/Authorization/AniList/Auth Token"_json_pointer);
	anilist.username = JSON::GetString(config_js, "/Authorization/AniList/Username"_json_pointer);
	anilist.user_id = JSON::GetInt(config_js, "/Authorization/AniList/User ID"_json_pointer);
	theme = Translate::ToTheme(JSON::GetString(config_js, "/Appearance/Theme"_json_pointer, "Default"));
	config.close();
	return 0;
}

int Config::Save() {
	Filesystem::Path cfg_path = Filesystem::GetConfigPath();
	if (!cfg_path.GetParent().Exists())
		cfg_path.GetParent().CreateDirectories();
	std::ofstream config(cfg_path.GetPath(), std::ofstream::out | std::ofstream::trunc);
	/* clang-format off */
	nlohmann::json config_js = {
		{"General",	{
			{"Service", Translate::ToString(service)}
		}},
		{"Anime List", {
			{"Title language", Translate::ToString(anime_list.language)},
			{"Display only aired episodes", anime_list.display_aired_episodes},
			{"Display only available episodes in library", anime_list.display_available_episodes},
			{"Highlight anime if available", anime_list.highlight_anime_if_available},
			{"Display highlighted anime above others", anime_list.highlighted_anime_above_others}
		}},
		{"Authorization", {
			{"AniList", {
				{"Auth Token", anilist.auth_token},
				{"Username", anilist.username},
				{"User ID", anilist.user_id}
			}}
		}},
		{"Appearance", {
			{"Theme", Translate::ToString(theme)}
		}}
	};
	/* clang-format on */
	config << std::setw(4) << config_js << std::endl;
	config.close();
	return 0;
}
