#include "bsd.h"
#include "os.h"
#include "linux.h"
#include "win32.h"
#include "animia.h"
#include <string>
#include <unordered_map>
#include <vector>

namespace Animia {

std::vector<int> get_all_pids() {
#ifdef ON_UNIX
	return Unix::get_all_pids();
#elif defined(ON_LINUX)
	return Linux::get_all_pids();
#elif defined(ON_WINDOWS)
	return Windows::get_all_pids();
#else
	return {};
#endif
}

std::string get_process_name(int pid) {
#ifdef ON_UNIX
	return Unix::get_process_name(pid);
#elif defined(ON_LINUX)
	return Linux::get_process_name(pid);
#elif defined(ON_WINDOWS)
	return Windows::get_process_name(pid);
#else
	return "";
#endif
}

std::vector<std::string> get_open_files(int pid) {
#ifdef ON_UNIX
	return Unix::get_open_files(pid);
#elif defined(ON_LINUX)
	return Linux::get_open_files(pid);
#elif defined(ON_WINDOWS)
	return Windows::get_open_files(pid);
#else
	return {};
#endif
}

std::vector<std::string> filter_system_files(const std::vector<std::string>& source) {
#ifdef ON_WINDOWS
	return Windows::filter_system_files(source);
#elif defined(ON_OSX)
	return Unix::filter_system_files(source);
#else
	return source;
#endif
}

std::unordered_map<int, std::vector<std::string>> get_all_open_files() {
#ifdef ON_UNIX
	return Unix::get_all_open_files();
#elif defined(ON_LINUX)
	return Linux::get_all_open_files();
#elif defined(ON_WINDOWS)
	return Windows::get_all_open_files();
#else
	return {};
#endif
}

} // namespace Animia
