#include "core/session.h"
#include "core/strings.h"
#include "gui/dialog/settings.h"
#include <QLineEdit>
#include <QGroupBox>
#include <QLabel>
#include <QSizePolicy>
#include <QVBoxLayout>
#include <algorithm>

QWidget* SettingsPageTorrents::CreateGeneralWidget() {
	QWidget* result = new QWidget(this);
	result->setAutoFillBackground(true);
	result->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QVBoxLayout* full_layout = new QVBoxLayout(result);

	{
		/* URLs */
		QGroupBox* group = new QGroupBox(tr("URLs"), result);
		group->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

		QVBoxLayout* group_layout = new QVBoxLayout(group);

		{
			/* Feed link */
			QWidget* widget = new QWidget(group);
			QVBoxLayout* widget_layout = new QVBoxLayout(widget);

			{
				QLabel* sync_combo_box_label = new QLabel(tr("URL of the RSS feed to check:"), widget);
				widget_layout->addWidget(sync_combo_box_label);
			}

			{
				/* Username: this literally never gets used btw */
				QLineEdit* lineedit = new QLineEdit(Strings::ToQString(feed_link), widget);
				connect(lineedit, &QLineEdit::editingFinished, this,
				        [this, lineedit] { feed_link = Strings::ToUtf8String(lineedit->text()); });
				widget_layout->addWidget(lineedit);
			}

			group_layout->addWidget(widget);
		}

		full_layout->addWidget(group);
	}

	full_layout->setSpacing(10);
	full_layout->addStretch();

	return result;
}

void SettingsPageTorrents::SaveInfo() {
	session.config.torrents.feed_link = feed_link;
}

SettingsPageTorrents::SettingsPageTorrents(QWidget* parent) : SettingsPage(parent, tr("Application")) {
	feed_link = session.config.torrents.feed_link;
	AddTab(CreateGeneralWidget(), tr("General"));
}
