#ifndef __core__anime_db_h
#define __core__anime_db_h

#include "core/anime.h"
#include "json/json_fwd.hpp"
#include <string>
#include <unordered_map>

namespace Anime {

class Database {
	public:
		std::unordered_map<int, Anime> items;
		size_t GetTotalAnimeAmount();
		size_t GetTotalEpisodeAmount();
		size_t GetTotalWatchedAmount();
		size_t GetTotalPlannedAmount();
		double GetAverageScore();
		double GetScoreDeviation();
		size_t GetListsAnimeAmount(ListStatus status);
		int GetAnimeFromTitle(const std::string& title);

		bool GetDatabaseAsJSON(nlohmann::json& json);
		bool SaveDatabaseToDisk();

		bool ParseDatabaseJSON(const nlohmann::json& json);
		bool LoadDatabaseFromDisk();
};

extern Database db;

} // namespace Anime


#endif // __core__anime_db_h
