#include "animia/win/quartz.h"
#include "animia.h"

#import <Foundation/Foundation.h>
#import <CoreGraphics/CoreGraphics.h>
#import <AppKit/AppKit.h>

namespace animia::internal::quartz {

template<typename T>
static bool IntegerFromNSNumber(NSNumber* num, T& result) {
	if (!num)
		return false;

	result = [num intValue];
	return true;
}

static bool StringFromNSString(NSString* string, std::string& result) {
	if (!string)
		return false;

	result = [string UTF8String];
	return true;
}

static bool GetWindowTitle(unsigned int wid, std::string& result) {
	NSWindow* window = [NSApp windowWithWindowNumber: wid];
	if (!window)
		return false;

	return StringFromNSString([window title], result);
}

bool QuartzWinTools::EnumerateWindows(window_proc_t window_proc) {
	if (!window_proc)
		return false;

	NSMutableArray* windows = reinterpret_cast<NSMutableArray*>(CGWindowListCopyWindowInfo(kCGWindowListOptionAll, kCGNullWindowID));
	if (!windows)
		return false;

	for (NSDictionary* window in windows) {
		if (!window)
			continue;

		Process proc;
		{
			IntegerFromNSNumber([window objectForKey:@"kCGWindowOwnerPID"], proc.pid);
			StringFromNSString([window objectForKey:@"kCGWindowOwnerName"], proc.name);
			if (proc.name.empty())
				osx::util::GetProcessName(proc.pid, proc.name);
		}

		Window win;
		{
			IntegerFromNSNumber([window objectForKey:@"kCGWindowNumber"], win.id);
			StringFromNSString([window objectForKey:@"kCGWindowName"], win.class_name);
			GetWindowTitle(win.id, win.text);
		}

		if (!window_proc(proc, win))
			return false;
	}

	return true;
}

} // namespace animia::win::detail
