#include "animia/fd.h"

#ifdef WIN32
#	include "animia/fd/win32.h"
#elif defined(LINUX) || defined(FREEBSD)
#	include "animia/fd/proc.h"
#elif defined(MACOSX)
#	include "animia/fd/xnu.h"
#elif defined(LIBUTIL)
#   include "animia/fd/libutil.h"
#endif

namespace animia::internal {

#ifdef WIN32
win32::Win32FdTools os_fd;
#elif defined(LINUX) || defined(FREEBSD)
proc::ProcFdTools os_fd;
#elif defined(MACOSX)
xnu::XnuFdTools os_fd;
#elif defined(LIBUTIL)
libutil::LibutilFdTools os_fd;
#else
BaseFdTools os_fd;
#endif

BaseFdTools& fd = os_fd;

} // namespace animia::internal
