#ifndef __gui__dialog__settings_h
#define __gui__dialog__settings_h

#include "core/anime.h"
#include "core/config.h"
#include "core/session.h"
#include <QDialog>
#include <QWidget>
#include <QLocale>

class QLabel;
class QTabWidget;
class QStackedWidget;
class SideBar;

class SettingsPage : public QWidget {
		Q_OBJECT

	public:
		SettingsPage(QWidget* parent = nullptr, QString title = "");
		void SetTitle(QString title);
		virtual void SaveInfo() = 0;
		void AddTab(QWidget* tab, QString title = "");

	private:
		QLabel* page_title;
		QTabWidget* tab_widget;
};

class SettingsPageServices final : public SettingsPage {
		Q_OBJECT

	public:
		SettingsPageServices(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateMainPage();
		QWidget* CreateAniListPage();
		QString username;
		Anime::Services service;
};

class SettingsPageApplication final : public SettingsPage {
		Q_OBJECT

	public:
		SettingsPageApplication(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateAnimeListWidget();
		Themes theme;
		QLocale locale;
		Anime::TitleLanguage language;
		bool display_aired_episodes;
		bool display_available_episodes;
		bool highlight_anime_if_available;
		bool highlighted_anime_above_others;
};

class SettingsPageTorrents final : public SettingsPage {
		Q_OBJECT

	public:
		SettingsPageTorrents(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreateGeneralWidget();
		decltype(session.config.torrents.feed_link) feed_link;
};

class SettingsPageRecognition final : public SettingsPage {
		Q_OBJECT

	public:
		SettingsPageRecognition(QWidget* parent = nullptr);
		void SaveInfo() override;

	private:
		QWidget* CreatePlayersWidget();
		decltype(session.config.recognition.detect_media_players) detect_media_players;
		decltype(session.config.recognition.players) players;
};

class SettingsDialog final : public QDialog {
		Q_OBJECT

	public:
		SettingsDialog(QWidget* parent = nullptr);
		QWidget* CreateServicesMainPage(QWidget* parent);
		void OnOK();

	protected:
		void showEvent(QShowEvent* event) override;

	private:
		SideBar* sidebar;
		QStackedWidget* stacked;
};

#endif // __gui__dialog__settings_h
