#include "bsd.h"
#include "linux.h"
#include "win32.h"
#include <vector>
#include <string>
#include <unordered_map>
#ifdef __linux__
#	define ON_LINUX
#elif (defined(unix) || defined(__unix__) || defined(__unix) || \
		(defined(__APPLE__) && defined(__MACH__)))
#	define ON_UNIX
#elif defined(_WIN32)
#	define ON_WINDOWS
#endif

namespace Animia {

std::vector<int> get_all_pids() {
#ifdef ON_UNIX
	return Unix::get_all_pids();
#elif defined(ON_LINUX)
	return Linux::get_all_pids();
#elif defined(ON_WINDOWS)
	return Windows::get_all_pids();
#else
	return {};
#endif
}

std::string get_process_name(int pid) {
#ifdef ON_UNIX
	return Unix::get_process_name(pid);
#elif defined(ON_LINUX)
	return Linux::get_process_name(pid);
#elif defined(ON_WINDOWS)
	return Windows::get_process_name(pid);
#else
	return "";
#endif
}

std::vector<std::string> get_open_files(int pid) {
#ifdef ON_UNIX
	return Unix::get_open_files(pid);
#elif defined(ON_LINUX)
	return Linux::get_open_files(pid);
#elif defined(ON_WINDOWS)
	return Windows::get_open_files(pid);
#else
	return {};
#endif
}

std::unordered_map<int, std::vector<std::string>> get_all_open_files() {
#ifdef ON_UNIX
	return Unix::get_all_open_files();
#elif defined(ON_LINUX)
	return Linux::get_all_open_files();
#elif defined(ON_WINDOWS)
	return Windows::get_all_open_files();
#else
	return {};
#endif
}

}
