#ifndef __gui__locale_h
#define __gui__locale_h

#include <QLocale>
#include <QTranslator>
#include <vector>
#include <string>
#include <memory>

namespace Locale {

std::string GetLocaleFullName(const QLocale& locale);

class Locale {
public:
	Locale();
	Locale(const std::string& name);
	QLocale GetLocale();
	std::vector<QLocale> GetAvailableLocales();
	void RefreshAvailableLocales(); // why would this ever be called?
	bool IsLocaleAvailable(const QLocale& locale);
	bool SetActiveLocale(const QLocale& locale);

private:
	bool SwitchTranslator(QTranslator& translator, const QString& name);

	QTranslator _translator;
	QTranslator _translator_qt;
	QLocale _locale;
	std::vector<QLocale> _available_translations = {};
};

}

#endif // __gui__locale_h
