#ifndef __window_h
#define __window_h
#include "core/config.h"
#include <QMainWindow>

class QWidget;
class QStackedWidget;
class QCloseEvent;
class SideBar;

class MainWindow final : public QMainWindow {
		Q_OBJECT

	public:
		MainWindow(QWidget* parent = nullptr);
		void SetActivePage(QWidget* page);
		void CreateBars();
		void AddMainWidgets();
		void RetranslateUI();
		void AsyncSynchronize(QStackedWidget* stack);
		void changeEvent(QEvent* event) override;
		void showEvent(QShowEvent* event) override;
		void closeEvent(QCloseEvent* event) override;

	private:
		QWidget* main_widget = nullptr;
		QStackedWidget* stack = nullptr;
		SideBar* sidebar = nullptr;
};

#endif // __window_h
