#ifndef __core__http_h
#define __core__http_h

#include <QThread>
#include <string>
#include <vector>

class QObject;

namespace HTTP {

class HttpGetThread : public QThread {
		Q_OBJECT

	public:
		HttpGetThread(std::string url, std::vector<std::string> headers = {}, QObject* parent = nullptr);

	private:
		static size_t WriteCallback(void* contents, size_t size, size_t nmemb, void* userdata);
		void run() override;
		std::string _url;
		std::vector<std::string> _headers;

	signals:
		void resultReady(const QByteArray& arr);
};

/* Performs a basic (blocking) post request */
std::string PerformBasicPostRequest(std::string url, std::string data, std::vector<std::string> headers = {});

} // namespace HTTP

#endif // __core__http_h
