#include "gui/widgets/poster.h"
#include "core/anime_db.h"
#include "core/http.h"
#include "core/session.h"
#include "core/strings.h"
#include "gui/widgets/clickable_label.h"
#include <QByteArray>
#include <QDebug>
#include <QDesktopServices>
#include <QFrame>
#include <QHBoxLayout>
#include <QLabel>
#include <QMessageBox>
#include <QPixmap>
#include <QUrl>
#include <curl/curl.h>

Poster::Poster(int id, QWidget* parent) : QFrame(parent) {
	QHBoxLayout* layout = new QHBoxLayout(this);
	layout->setContentsMargins(1, 1, 1, 1);

	setCursor(Qt::PointingHandCursor);
	setFixedSize(150, 225);
	setFrameShape(QFrame::Box);
	setFrameShadow(QFrame::Plain);

	const Anime::Anime& anime = Anime::db.items[id];

	HTTP::HttpGetThread* image_thread = new HTTP::HttpGetThread(anime.GetPosterUrl(), {}, this);
	connect(image_thread, &HTTP::HttpGetThread::resultReady, this, &Poster::ImageDownloadFinished);
	connect(image_thread, &HTTP::HttpGetThread::finished, image_thread, &QObject::deleteLater);
	image_thread->start();

	QPixmap pixmap = QPixmap::fromImage(img);

	label = new ClickableLabel(this);
	label->setAlignment(Qt::AlignCenter);
	connect(label, &ClickableLabel::clicked, this,
	        [anime] { QDesktopServices::openUrl(Strings::ToQString(anime.GetServiceUrl())); });
	layout->addWidget(label);
}

void Poster::ImageDownloadFinished(QByteArray arr) {
	img.loadFromData(arr);
	RenderToLabel();
}

void Poster::RenderToLabel() {
	QPixmap pixmap = QPixmap::fromImage(img);
	if (pixmap.isNull())
		return;
	label->setPixmap(pixmap.scaled(label->size(), Qt::KeepAspectRatioByExpanding, Qt::SmoothTransformation));
}

void Poster::resizeEvent(QResizeEvent*) {
	RenderToLabel();
}

#include "gui/widgets/moc_poster.cpp"
