#ifndef MINORI_CORE_SESSION_H_
#define MINORI_CORE_SESSION_H_

#include "core/config.h"
#include "gui/locale.h"

#include <QObject>
#include <QElapsedTimer>

#include "semver/semver.hpp"

#include <atomic>
#include <string>

class MainWindow;

struct Session : public QObject {
	Q_OBJECT

public:
	Session();

	void SetMainWindow(MainWindow* window);

	void SetStatusBar(const std::string& message);

	/* we literally *cannot* be lying to the user by doing this */
	void IncrementRequests();
	unsigned int GetRequests();
	int uptime();

	Config config;
	static constexpr semver::version version{PACKAGE_VERSION};

signals:
	void StatusBarChange(const std::string& message);

private:
	/* IncrementRequests() gets called by different threads */
	std::atomic<unsigned int> requests_ = 0;
	QElapsedTimer timer_;
	MainWindow* window_;
};

extern Session session;

#endif // MINORI_CORE_SESSION_H_
