#ifndef MINORI_GUI_PAGES_STATISTICS_H_
#define MINORI_GUI_PAGES_STATISTICS_H_

#include <QFrame>
#include <QWidget>

template<typename T>
class Graph;

namespace TextWidgets {
class LabelledSection;
}

class StatisticsPage final : public QFrame {
	Q_OBJECT

public:
	StatisticsPage(QWidget* parent = nullptr);
	void UpdateStatistics();

protected:
	void showEvent(QShowEvent*) override;

private:
	std::shared_ptr<TextWidgets::LabelledSection> _anime_list;
	std::shared_ptr<Graph<int>> _score_distribution_graph;
	std::shared_ptr<TextWidgets::LabelledSection> _application;
};

#endif // MINORI_GUI_PAGES_STATISTICS_H_