#ifndef __gui__dialog__information_h
#define __gui__dialog__information_h

#include "core/anime.h"
#include "core/date.h"
#include <QDialog>
#include <functional>

class InformationDialog final : public QDialog {
		Q_OBJECT

	public:
		enum Pages {
			PAGE_MAIN_INFO,
			PAGE_MY_LIST
		};

		InformationDialog(Anime::Anime& anime, std::function<void()> accept = {},
			              enum Pages page = Pages::PAGE_MAIN_INFO, QWidget* parent = nullptr);

	protected:
		void showEvent(QShowEvent* event) override;

	private:
		void SaveData(Anime::Anime& anime);
		unsigned int _progress;
		unsigned int _score;
		bool _rewatching;
		Anime::ListStatus _status;
		std::string _notes;
		Date _started;
		Date _completed;
};

#endif // __gui__dialog__information_h
