/**
 * config.cpp:
 * parses the config... lol
 **/
#include "core/config.h"
#include "core/strings.h"
#include "core/anime.h"
#include "core/ini.h"
#include "core/filesystem.h"
#include "core/json.h"
#include "gui/translate/anime.h"
#include "gui/translate/config.h"
#include <algorithm>
#include <cstdlib>
#include <cstring>
#include <filesystem>
#include <fstream>
#include <limits.h>

int Config::Load() {
	Filesystem::Path cfg_path = Filesystem::GetConfigPath();

	mINI::INIFile file(cfg_path.GetPath());
	mINI::INIStructure ini;
	file.read(ini);

	service = Translate::ToService(INI::GetIniString(ini, "General", "Service", "None"));
	/* ew */
	locale.SetActiveLocale(QLocale(Strings::ToQString(INI::GetIniString(ini, "General", "Locale", "en_US"))));

	anime_list.language = Translate::ToLanguage(INI::GetIniString(ini, "Anime List", "Title language", "Romaji"));
	anime_list.display_aired_episodes = Strings::ToBool(INI::GetIniString(ini, "Anime List", "Display only aired episodes", ""), true);
	anime_list.display_available_episodes = Strings::ToBool(INI::GetIniString(ini, "Anime List", "Display only available episodes in library", ""), true);
	anime_list.highlight_anime_if_available = Strings::ToBool(INI::GetIniString(ini, "Anime List", "Highlight anime if available", ""), true);
	anime_list.highlighted_anime_above_others = Strings::ToBool(INI::GetIniString(ini, "Anime List", "Display highlighted anime above others", ""), false);

	anilist.auth_token = INI::GetIniString(ini, "AniList", "Auth Token", "");
	anilist.user_id = Strings::ToInt(INI::GetIniString(ini, "AniList", "User ID", ""), 0);

	torrents.feed_link = INI::GetIniString(ini, "Torrents", "RSS feed", "https://www.tokyotosho.info/rss.php?filter=1,11&zwnj=0");

	theme.SetTheme(Translate::ToTheme(INI::GetIniString(ini, "Appearance", "Theme", "Default")));

	return 0;
}

int Config::Save() const {
	Filesystem::Path cfg_path = Filesystem::GetConfigPath();
	if (!cfg_path.GetParent().Exists())
		cfg_path.GetParent().CreateDirectories();

	mINI::INIFile file(cfg_path.GetPath());
	mINI::INIStructure ini;

	ini["General"]["Service"] = Translate::ToString(service);
	ini["General"]["Locale"] = Strings::ToUtf8String(locale.GetLocale().name());
	ini["Anime List"]["Title language"] = Translate::ToString(anime_list.language);
	ini["Anime List"]["Display only aired episodes"] = Strings::ToUtf8String(anime_list.display_aired_episodes);
	ini["Anime List"]["Display only available episodes in library"] = Strings::ToUtf8String(anime_list.display_available_episodes);
	ini["Anime List"]["Highlight anime if available"] = Strings::ToUtf8String(anime_list.highlight_anime_if_available);
	ini["Anime List"]["Display highlighted anime above others"] = Strings::ToUtf8String(anime_list.highlighted_anime_above_others);
	ini["AniList"]["Auth Token"] = anilist.auth_token;
	ini["AniList"]["User ID"] = std::to_string(anilist.user_id);
	ini["Appearance"]["Theme"] = Translate::ToString(theme.GetTheme());
	ini["Torrents"]["RSS feed"] = torrents.feed_link;

	file.write(ini);

	return 0;
}
