#ifndef __gui__dialog__information_h
#define __gui__dialog__information_h
#include <QDialog>
#include <functional>
#include "core/date.h"
#include "core/anime.h"

class InformationDialog : public QDialog {
		Q_OBJECT

	public:
		InformationDialog(const Anime::Anime& anime, std::function<void()> accept, QWidget* parent = nullptr);

	private:
		unsigned int id;
		unsigned int progress;
		unsigned int episodes;
		unsigned int score;
		bool rewatching;
		Anime::ListStatus status;
		std::string notes;
		Date started;
		Date completed;
		void SaveData();
};
#endif // __gui__dialog__information_h
