#include "services/services.h"
#include "core/session.h"
#include "gui/dialog/settings.h"
#include "services/anilist.h"

namespace Services {

void Synchronize() {
	switch (session.config.service) {
		case Anime::Service::AniList: AniList::GetAnimeList(); break;
		default: break;
	}
}

std::vector<int> Search(const std::string& search) {
	switch (session.config.service) {
		case Anime::Service::AniList: return AniList::Search(search);
		default: return {};
	}
}

void UpdateAnimeEntry(int id) {
	switch (session.config.service) {
		case Anime::Service::AniList: AniList::UpdateAnimeEntry(id); break;
		default: break;
	}
}

bool Authorize() {
	switch (session.config.service) {
		case Anime::Service::AniList: return AniList::AuthorizeUser();
		default: return true;
	}
}

}; // namespace Services
