#include <regex>

#include "animone.h"
#include "animone/fd.h"
#include "animone/strategies.h"
#include "animone/util.h"

#include <iostream>

/* this was STUPIDLY slow in Anisthesia, oops! */

namespace animone::internal {

static bool ApplyWindowTitleFormat(const std::string& format, std::string& title) {
	if (format.empty())
		return false;

	const std::regex pattern(format);
	std::smatch match;
	std::regex_match(title, match, pattern);

	// Use the first non-empty match result, because the regular expression may
	// contain multiple sub-expressions.
	for (size_t i = 1; i < match.size(); ++i) {
		if (!match.str(i).empty()) {
			title = match.str(i);
			return true;
		}
	}

	// Results are empty, but the match was successful
	if (!match.empty()) {
		title.clear();
		return true;
	}

	return true;
}

static MediaInfoType InferMediaInformationType(const std::string& str) {
	const std::regex path_pattern(R"(^(?:[A-Za-z]:[/\\]|\\\\)[^<>:"/\\|?*]+)");
	return (std::regex_search(str, path_pattern)) ? MediaInfoType::File : MediaInfoType::Unknown;
}

static bool AddMedia(Result& result, const MediaInfo media_information) {
	if (media_information.value.empty())
		return false;

	Media media;
	media.information.push_back(media_information);
	result.media.push_back(std::move(media));

	return true;
}

static bool ApplyWindowTitleStrategy(std::vector<Result>& results) {
	bool success = false;

	for (auto& result : results) {
		auto title = result.window.text;
		if (title.empty())
			continue;

		ApplyWindowTitleFormat(result.player.window_title_format, title);

		success |= AddMedia(result, {InferMediaInformationType(title), title});
	}

	return success;
}

static bool ApplyOpenFilesStrategy(std::vector<Result>& results) {
	bool success = false;

	/* map pids to our results, saves time with open_file_proc */
	std::unordered_map<pid_t, Result*> pid_map;
	std::set<pid_t> pids;

	for (Result& result : results) {
		const pid_t pid = result.process.pid;
		if (!pid)
			continue;

		pid_map.insert({pid, &result});
		pids.insert(pid);
	}

	auto open_file_proc = [&](const OpenFile& file) -> bool {
		success |= AddMedia(*pid_map[file.pid], {MediaInfoType::File, file.path});
		return true;
	};

	EnumerateOpenFiles(pids, open_file_proc);

	return success;
}

bool ApplyStrategies(std::vector<Result>& results) {
	bool success = false;

	success |= ApplyWindowTitleStrategy(results);
	success |= ApplyOpenFilesStrategy(results);

	return success;
}

////////////////////////////////////////////////////////////////////////////////

} // namespace animone::internal
