#ifndef __core__strings_h
#define __core__strings_h

#include <string>
#include <vector>

namespace Strings {

/* Implode function: takes a vector of strings and turns it
   into a string, separated by delimiters. */
std::string Implode(const std::vector<std::string>& vector, const std::string& delimiter);

/* Substring removal functions */
std::string ReplaceAll(const std::string& string, const std::string& find, const std::string& replace);
std::string SanitizeLineEndings(const std::string& string);
std::string RemoveHtmlTags(const std::string& string);

/* stupid HTML bullshit */
std::string TextifySynopsis(const std::string& string);

std::string ToUpper(const std::string& string);
std::string ToLower(const std::string& string);

};	// namespace StringUtils
#endif // __core__strings_h