/*
 * fd/openbsd.cc: support for OpenBSD
 *
 * COMPLETELY UNTESTED. may or may not work.
 */
#include "animone/fd/bsd.h"
#include "animone.h"
#include "animone/fd.h"

#include <sys/file.h>
#include <sys/filedesc.h>
#include <sys/param.h>
#include <sys/queue.h>
#include <sys/sysctl.h>
#include <sys/types.h>
#include <sys/user.h>
#include <sys/vnode.h>

#include <kvm.h>
#include <fts.h>

#include <string>

namespace animone::internal::openbsd {

/* XXX is this necessary */
static std::string Basename(const std::string& name) {
	size_t s = name.find_last_of('/');

	if (s == std::string::npos)
		return name;

	return name.substr(s, name.size());
}

bool GetProcessName(pid_t pid, std::string& name) {
	char errbuf[_POSIX2_LINE_MAX];
	kvm_t* kernel = kvm_openfiles(NULL, NULL, NULL, O_RDONLY, errbuf);
	if (!kernel)
		return false;

	int entries = 0;
	struct kinfo_proc* kinfo = kvm_getprocs(kernel, KERN_PROC_PID, pid, &entries);
	if (!kinfo) {
		kvm_close(kernel);
		return false;
	}

	if (entries < 1) {
		kvm_close(kernel);
		return false;
	}

	name = Basename(kinfo[0].ki_paddr->p_comm);

	return true;
}

bool EnumerateOpenProcesses(process_proc_t process_proc) {
	char errbuf[_POSIX2_LINE_MAX];
	kvm_t* kernel = kvm_openfiles(NULL, NULL, NULL, O_RDONLY, errbuf);
	if (!kernel)
		return false;

	int entries = 0;
	struct kinfo_proc* kinfo = kvm_getprocs(kernel, KERN_PROC_ALL, 0, &entries);
	if (!kinfo) {
		kvm_close(kernel);
		return false;
	}

	for (int i = 0; i < entries; i++) {
		if (!process_proc({.platform = ExecutablePlatform::Posix, .pid = kinfo[i].ki_paddr->p_pid, .comm = Basename(kinfo[i].ki_paddr->p_comm)})) {
			kvm_close(kernel);
			return false;
		}
	}

	kvm_close(kernel);

	return true;
}

static bool GetOpenFileName(const struct kinfo_file& file, std::string& name) {
	/* OpenBSD doesn't provide a native API for this, so we have
	 * to do it ourselves */
	static constexpr std::string_view root = "/";

	FTS* file_system = fts_open(root.data(), FTS_COMFOLLOW | FTS_NOCHDIR, nullptr);
	if (!file_system)
		return false;

	/* Search through the filesystem for a file that matches our
	 * kinfo_file structure */
	FTSENT* parent = nullptr;
	while ((parent = fts_read(file_system))) {
		FTSENT* child = fts_children(file_system, 0);
		while (child && child->fts_link) {
			child = child->fts_link;
			if (!S_ISREG(child->fts_statp->st_mode) || !S_ISLNK(child->fts_statp->st_mode))
				continue;

			if (child->fts_statp->st_dev != file->va_fsid)
				continue;

			if (child->fts_statp->st_ino != file->va_fileid)
				continue;

			name = std::string(child->fts_path) + child->fts_name;
			fts_close(file_system);
			return true;
		}
	}

	fts_close(filesystem);
	return false;
}

bool EnumerateOpenFiles(const std::set<pid_t>& pids, open_file_proc_t open_file_proc) {
	char errbuf[_POSIX2_LINE_MAX];
	kvm_t* kernel = kvm_openfiles(nullptr, nullptr, nullptr, O_RDONLY, errbuf);
	if (!kernel)
		return false;

	for (const auto& pid : pids) {
		int cnt;
		struct kinfo_file* kfile = kvm_getfiles(kernel, KERN_FILE_BYPID, pid, &cnt);
		if (!kfile) {
			kvm_close(kernel);
			return false;
		}

		for (int i = 0; i < cnt; i++) {
			uint32_t oflags = kfile[i].kf_flags & O_ACCMODE;
			if (oflags == O_WRONLY || oflags == O_RDWR)
				continue;

			std::string name;
			if (!GetOpenFileName(kfile[i], name))
				continue;

			if (!open_file_proc({pid, name})) {
				kvm_close(kernel);
				return false;
			}
		}
	}

	kvm_close(kernel);
	return true;
}

} // namespace animone::internal::openbsd
