#include "core/session.h"
#include "core/config.h"
#include "core/strings.h"
#include "gui/locale.h"
#include "gui/window.h"

#include <QElapsedTimer>
#include <QStatusBar>

#include "semver/semver.hpp"

#include <atomic>

Session session;

Session::Session() : gen(Time::GetSystemTime())
{
	timer_.start();
}

void Session::SetMainWindow(MainWindow *window)
{
	disconnect();
	window_ = window;
	connect(this, &Session::StatusBarChange, window_, &MainWindow::SetStatusMessage);
}

void Session::SetStatusBar(const std::string &message)
{
	emit StatusBarChange(message);
}

void Session::IncrementRequests()
{
	requests_++;
};

unsigned int Session::GetRequests()
{
	return requests_;
};

std::int64_t Session::uptime()
{
	return timer_.elapsed();
}
