#include "core/anime.h"
#include "gui/translate/anime.h"
#include <QCoreApplication>

namespace Translate {

std::string ToString(const Anime::ListStatus status) {
	switch (status) {
		case Anime::ListStatus::NOT_IN_LIST: return QCoreApplication::tr("Not in list").toStdString();
		case Anime::ListStatus::CURRENT: return QCoreApplication::tr("Currently watching").toStdString();
		case Anime::ListStatus::PLANNING: return QCoreApplication::tr("Plan to watch").toStdString();
		case Anime::ListStatus::COMPLETED: return QCoreApplication::tr("Completed").toStdString();
		case Anime::ListStatus::DROPPED: return QCoreApplication::tr("Dropped").toStdString();
		case Anime::ListStatus::PAUSED: return QCoreApplication::tr("On hold").toStdString();
		default: return "";
	}
}

std::string ToString(const Anime::SeriesFormat format) {
	switch (format) {
		case Anime::SeriesFormat::UNKNOWN: return QCoreApplication::tr("Unknown").toStdString();
		case Anime::SeriesFormat::TV: return QCoreApplication::tr("TV").toStdString();
		case Anime::SeriesFormat::TV_SHORT: return QCoreApplication::tr("TV short").toStdString();
		case Anime::SeriesFormat::OVA: return QCoreApplication::tr("OVA").toStdString();
		case Anime::SeriesFormat::MOVIE: return QCoreApplication::tr("Movie").toStdString();
		case Anime::SeriesFormat::SPECIAL: return QCoreApplication::tr("Special").toStdString();
		case Anime::SeriesFormat::ONA: return QCoreApplication::tr("ONA").toStdString();
		case Anime::SeriesFormat::MUSIC: return QCoreApplication::tr("Music").toStdString();
		default: return "";
	}
}

std::string ToString(const Anime::SeriesSeason season) {
	switch (season) {
		case Anime::SeriesSeason::UNKNOWN: return QCoreApplication::tr("Unknown").toStdString();
		case Anime::SeriesSeason::WINTER: return QCoreApplication::tr("Winter").toStdString();
		case Anime::SeriesSeason::SUMMER: return QCoreApplication::tr("Summer").toStdString();
		case Anime::SeriesSeason::FALL: return QCoreApplication::tr("Fall").toStdString();
		case Anime::SeriesSeason::SPRING: return QCoreApplication::tr("Spring").toStdString();
		default: return "";
	}
}

std::string ToString(const Anime::SeriesStatus status) {
	switch (status) {
		case Anime::SeriesStatus::UNKNOWN: return QCoreApplication::tr("Unknown").toStdString();
		case Anime::SeriesStatus::RELEASING: return QCoreApplication::tr("Currently airing").toStdString();
		case Anime::SeriesStatus::FINISHED: return QCoreApplication::tr("Finished airing").toStdString();
		case Anime::SeriesStatus::NOT_YET_RELEASED: return QCoreApplication::tr("Not yet aired").toStdString();
		case Anime::SeriesStatus::CANCELLED: return QCoreApplication::tr("Cancelled").toStdString();
		case Anime::SeriesStatus::HIATUS: return QCoreApplication::tr("On hiatus").toStdString();
		default: return "";
	}
}

} // namespace Translate
