#ifndef __animia__animia__fd_h
#define __animia__animia__fd_h

#include <set>
#include <string>
#include <tuple>
#include <string>
#include <vector>

#include "animia/types.h"

namespace animia::internal {

class BaseFdTools {
	public:
		virtual bool GetAllPids(std::set<pid_t>& pids) { return false; }
		virtual bool GetProcessName(pid_t pid, std::string& result) { return false; }
		virtual bool EnumerateOpenFiles(const std::set<pid_t>& pids, std::vector<std::tuple<pid_t, std::string>>& files) { return false; }
};

extern BaseFdTools& fd; // defined in animia.cc

}

#endif // __animia__animia__fd_h
