#ifndef ANIMONE_ANIMONE_A11Y_H_
#define ANIMONE_ANIMONE_A11Y_H_

#include <functional>
#include <string>

#include "animone.h"

namespace animone {
namespace internal {

enum class WebBrowserInformationType {
	Address,
	Tab,
	Title,
};

struct WebBrowserInformation {
	WebBrowserInformationType type = WebBrowserInformationType::Title;
	std::string value;
};

using web_browser_proc_t = std::function<void(const WebBrowserInformation&)>;

bool GetWebBrowserInformation(const Result& result, web_browser_proc_t web_browser_proc);

} // namespace internal
} // namespace animone

#endif // ANIMONE_ANIMONE_A11Y_H_
