#ifndef MINORI_CORE_ANIME_SEASON_H_
#define MINORI_CORE_ANIME_SEASON_H_

#include "core/date.h" /* Date::Month */

#include <array>

namespace Anime {

class Season final {
public:
	enum class Name {
		Unknown,
		Winter,
		Spring,
		Summer,
		Autumn,
	};

	static constexpr std::array<Name, 4> Names{
	    Name::Winter,
	    Name::Spring,
	    Name::Summer,
	    Name::Autumn,
	};

	Season() = default;
	Season(Name s, Date::Year y);
	explicit Season(const Date &date);

	bool operator==(const Season &o) const;
	bool operator!=(const Season &o) const;

	bool operator<(const Season &o) const;
	bool operator>(const Season &o) const;
	bool operator<=(const Season &o) const;
	bool operator>=(const Season &o) const;

	Season &operator++();
	Season &operator--();

	Name season = Name::Unknown;
	Date::Year year = 0;
};

} // namespace Anime

#endif // MINORI_CORE_ANIME_SEASON_H_
