#ifndef __core__config_h
#define __core__config_h

#include "core/anime.h"
#include "gui/theme.h"
#include "gui/locale.h"

#include "animia/player.h"

#include <string>
#include <vector>
#include <utility>

struct MediaPlayer {
	bool enabled = true;
	animia::Player player;
};

class Config {
	public:
		int Load();
		int Save() const;

		Anime::Services service;
		Theme::Theme theme;
		Locale::Locale locale;

		struct {
			public:
				Anime::TitleLanguage language;
				Anime::ScoreFormat score_format;
				bool display_aired_episodes;
				bool display_available_episodes;
				bool highlight_anime_if_available;
				bool highlighted_anime_above_others;
		} anime_list;

		/* these should preferably be in an
		   "auth" struct... */
		struct {
			public:
				struct {
					public:
						std::string auth_token;
						std::string username;
						int user_id;
				} anilist;
		} auth;

		struct {
			public:
				bool detect_media_players;
				std::vector<MediaPlayer> players;
		} recognition;

		struct {
			public:
				std::string feed_link;
		} torrents;
};

#if (defined(WIN32) || defined(MACOSX))
constexpr std::string_view CONFIG_DIR = "Minori";
#else
constexpr std::string_view CONFIG_DIR = "minori";
#endif

constexpr std::string_view CONFIG_NAME = "config.ini";

#endif // __core__config_h
