#ifndef __gui__pages__anime_list_h
#define __gui__pages__anime_list_h

#include "core/anime.h"
#include <QAbstractListModel>
#include <QSortFilterProxyModel>
#include <QStyledItemDelegate>
#include <QWidget>
#include <vector>

class QTreeView;
class QTabBar;

class AnimeListPageDelegate : public QStyledItemDelegate {
		Q_OBJECT

	public:
		explicit AnimeListPageDelegate(QObject* parent);

		QWidget* createEditor(QWidget*, const QStyleOptionViewItem&, const QModelIndex&) const override;
		void paint(QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index) const override;
};

class AnimeListPageSortFilter : public QSortFilterProxyModel {
		Q_OBJECT

	public:
		AnimeListPageSortFilter(QObject* parent = nullptr);

	protected:
		bool lessThan(const QModelIndex& l, const QModelIndex& r) const override;
};

class AnimeListPageModel : public QAbstractListModel {
		Q_OBJECT

	public:
		enum columns {
			AL_TITLE,
			AL_PROGRESS,
			AL_EPISODES,
			AL_SCORE,
			AL_AVG_SCORE,
			AL_TYPE,
			AL_SEASON,
			AL_STARTED,
			AL_COMPLETED,
			AL_UPDATED,
			AL_NOTES,

			NB_COLUMNS
		};

		AnimeListPageModel(QWidget* parent, Anime::ListStatus _status);
		~AnimeListPageModel() override = default;
		int rowCount(const QModelIndex& parent = QModelIndex()) const override;
		int columnCount(const QModelIndex& parent = QModelIndex()) const override;
		QVariant data(const QModelIndex& index, int role) const override;
		QVariant headerData(const int section, const Qt::Orientation orientation, const int role) const override;
		void RefreshList();
		Anime::Anime* GetAnimeFromIndex(QModelIndex index);

	private:
		Anime::ListStatus status;
		std::vector<Anime::Anime> list;
};

/* todo: rename these to "page" or something more
   sensible than "widget" */
class AnimeListPage : public QWidget {
		Q_OBJECT

	public:
		AnimeListPage(QWidget* parent);
		void Refresh();
		void Reset();

	protected:
		void paintEvent(QPaintEvent*) override;
		void InitStyle(QStyleOptionTabWidgetFrame* option) const;
		void InitBasicStyle(QStyleOptionTabWidgetFrame* option) const;
		void SetupLayout();
		void showEvent(QShowEvent*) override;
		void resizeEvent(QResizeEvent* e) override;
		void RefreshList();
		void RefreshTabs();
		void UpdateAnime(int id);
		void RemoveAnime(int id);

	private slots:
		void DisplayColumnHeaderMenu();
		void DisplayListMenu();
		void ItemDoubleClicked();
		void SetColumnDefaults();
		int VisibleColumnsCount() const;

	private:
		QTabBar* tab_bar;
		QTreeView* tree_view;
		QRect panelRect;
		std::array<AnimeListPageSortFilter*, 5> sort_models;
};

#endif // __gui__pages__anime_list_h