#ifdef WIN32
#include <shlobj.h>
#elif defined(MACOSX)
#include "sys/osx/filesystem.h"
#elif defined(__linux__)
#include <pwd.h>
#include <sys/types.h>
#include <unistd.h>
#endif
#include "core/config.h"
#include "core/filesystem.h"
#include "core/strings.h"
#include <QMessageBox>
#include <filesystem>
#include <limits.h>

std::filesystem::path get_config_path(void) {
	std::filesystem::path cfg_path;
#ifdef WIN32
	char buf[PATH_MAX + 1];
	if (SHGetFolderPathAndSubDir(NULL, CSIDL_APPDATA | CSIDL_FLAG_CREATE, NULL, 0, CONFIG_DIR, buf) == S_OK)
		cfg_path = std::filesystem::path(buf) / CONFIG_NAME;
#elif defined(MACOSX)
	/* pass all of our problems to */
	cfg_path = std::filesystem::path(osx::GetApplicationSupportDirectory()) / CONFIG_DIR / CONFIG_NAME;
#else // just assume POSIX
	if (getenv("HOME") != NULL)
		cfg_path = std::filesystem::path(getenv("HOME")) / ".config" / CONFIG_DIR / CONFIG_NAME;
#ifdef __linux__
	else
		cfg_path = std::filesystem::path(getpwuid(getuid())->pw_dir) / ".config" / CONFIG_DIR / CONFIG_NAME;
#endif // __linux__
#endif // !WIN32 && !MACOSX
	return cfg_path;
}
