#ifndef __core__filesystem_h
#define __core__filesystem_h
#include <string>

namespace Filesystem {

class Path {
        public:
                Path();
                Path(const std::string& path);
                Path(const Path& path);
                bool CreateDirectories() const;
                bool Exists() const;
                std::string Basename() const;
                std::string Stem() const;
                std::string Extension() const;
                Path GetParent() const;
                void SetPath(const std::string& path);
		std::string GetPath() const;

        private:
                std::string _path;
};

Path GetDotPath(); // %APPDATA%/minori, ~/Library/Application Support/minori, ~/.config/minori...
Path GetConfigPath(); // (dotpath)/config.json
Path GetAnimeDBPath(); // (dotpath)/anime/db.json

} // namespace Filesystem

#endif // __core__filesystem_h
