#ifndef __core__config_h
#define __core__config_h
#include "core/anime.h"

enum class Themes {
	LIGHT,
	DARK,
	OS // AKA "Default"
};

class Config {
	public:
		int Load();
		int Save();

		Anime::Services service;
		Themes theme;

		struct {
			public:
				Anime::TitleLanguage language;
				bool display_aired_episodes;
				bool display_available_episodes;
				bool highlight_anime_if_available;
				bool highlighted_anime_above_others;
		} anime_list;

		struct {
			public:
				std::string auth_token;
				std::string username;
				int user_id;
		} anilist;
};

#define WIDEIFY_EX(x) L ## x
#define WIDEIFY(x) WIDEIFY_EX(x)
#define CONFIG_DIR      "minori"
#define CONFIG_WDIR     WIDEIFY(CONFIG_DIR)
#define CONFIG_NAME     "config.json"
#define CONFIG_WNAME    WIDEIFY(CONFIG_NAME)

#define MAX_LINE_LENGTH 256
#endif // __core__config_h
