#include "gui/widgets/optional_date.h"
#include "core/date.h"
#include <QCheckBox>
#include <QDateEdit>
#include <QHBoxLayout>

OptionalDate::OptionalDate(QWidget* parent) {
	OptionalDate(false, parent);
}

OptionalDate::OptionalDate(bool enabled, QWidget* parent) : QWidget(parent) {
	QHBoxLayout* layout = new QHBoxLayout(this);
	layout->setContentsMargins(0, 0, 0, 0);

	_checkbox = new QCheckBox(this);
	_checkbox->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::Preferred);

	layout->addWidget(_checkbox, 0, Qt::AlignVCenter);

	_dateedit = new QDateEdit(this);
	_dateedit->setDisplayFormat("yyyy-MM-dd");
	_dateedit->setCalendarPopup(true);
	_dateedit->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred);

	layout->addWidget(_dateedit);

	SetEnabled(enabled);
	connect(_checkbox, &QCheckBox::stateChanged, this, [this](int state) {
		SetEnabled(state == Qt::Checked);
		emit DataChanged(IsEnabled(), GetDate());
	});
	connect(_dateedit, &QDateEdit::dateChanged, this, [this](QDate) {
		emit DataChanged(IsEnabled(), GetDate());
	});
}

void OptionalDate::SetEnabled(bool enabled) {
	_checkbox->setCheckState(enabled ? Qt::Checked : Qt::Unchecked);
	_dateedit->setEnabled(enabled);
}

bool OptionalDate::IsEnabled() {
	return _dateedit->isEnabled();
}

void OptionalDate::SetDate(QDate date) {
	_dateedit->setDate(date);
}

void OptionalDate::SetDate(Date date) {
	if (!date.IsValid()) return;
	SetDate(date.GetAsQDate());
}

Date OptionalDate::GetDate() {
	return Date(_dateedit->date());
}

QDateEdit* OptionalDate::GetDateEdit() {
	return _dateedit;
}

QCheckBox* OptionalDate::GetCheckBox() {
	return _checkbox;
}

#include "gui/widgets/moc_optional_date.cpp"
