#include "gui/widgets/sidebar.h"
#include <QFrame>
#include <QListWidget>
#include <QListWidgetItem>
#include <QMessageBox>
#include <QMouseEvent>
#include <QDebug>

SideBar::SideBar(QWidget* parent) : QListWidget(parent) {
	setFrameShape(QFrame::NoFrame);
	setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
	setSelectionMode(QAbstractItemView::SingleSelection);
	setSelectionBehavior(QAbstractItemView::SelectItems);
	setMouseTracking(true);
	/* FIXME: is there an easy way to do this with palettes? */
	setStyleSheet("QListWidget::item:disabled { background: transparent }");
	viewport()->setAutoFillBackground(false);

	QFont font;
	font.setPointSize(9);
	setFont(font);

	connect(this, &QListWidget::currentRowChanged, this,
	        [this](int index) { emit CurrentItemChanged(RemoveSeparatorsFromIndex(index)); });
}

void SideBar::SetCurrentItem(int index) {
	setCurrentRow(AddSeparatorsToIndex(index));
}

QListWidgetItem* SideBar::AddItem(QString name, QIcon icon) {
	QListWidgetItem* item = new QListWidgetItem(this);
	item->setText(name);
	if (!icon.isNull())
		item->setIcon(icon);
	return item;
}

QIcon SideBar::CreateIcon(const char* file) {
	QPixmap pixmap(file, "PNG");
	QIcon result;
	result.addPixmap(pixmap, QIcon::Normal);
	result.addPixmap(pixmap, QIcon::Selected);
	return result;
}

QListWidgetItem* SideBar::AddSeparator() {
	QListWidgetItem* item = new QListWidgetItem(this);
	QFrame* line = new QFrame(this);
	line->setFrameShape(QFrame::HLine);
	line->setFrameShadow(QFrame::Sunken);
	line->setMouseTracking(true);
	line->setEnabled(false);

	/*
	QPalette pal;
	pal.setColor(QPalette::Window, Qt::transparent);
	line->setPalette(pal);
	*/

	setItemWidget(item, line);
	item->setFlags(Qt::NoItemFlags);
	return item;
}

int SideBar::AddSeparatorsToIndex(int index) {
	int i, j;
	for (i = 0, j = 0; i < index; ) {
		i++;
		if (IndexIsSeparator(indexFromItem(item(i))))
			j++;
	}
	return i+j;
}

int SideBar::RemoveSeparatorsFromIndex(int index) {
	int i, j;
	for (i = 0, j = 0; i < index; i++) {
		if (!IndexIsSeparator(indexFromItem(item(i))))
			j++;
	}
	return j;
}

bool SideBar::IndexIsSeparator(QModelIndex index) const {
	return !(index.isValid() && index.flags() & Qt::ItemIsEnabled);
}

QItemSelectionModel::SelectionFlags SideBar::selectionCommand(const QModelIndex& index, const QEvent*) const {
	if (IndexIsSeparator(index))
		return QItemSelectionModel::NoUpdate;
	return QItemSelectionModel::ClearAndSelect;
}

void SideBar::mouseMoveEvent(QMouseEvent* event) {
	if (!IndexIsSeparator(indexAt(event->pos())))
		setCursor(Qt::PointingHandCursor);
	else
		unsetCursor();
	QListView::mouseMoveEvent(event);
}

#include "gui/widgets/moc_sidebar.cpp"
