#ifndef __gui__widgets__anime_info_h
#define __gui__widgets__anime_info_h

#include <QWidget>

namespace TextWidgets {
class OneLineSection;
class LabelledSection;
class SelectableSection;
}

namespace Anime {
class Anime;
}

class AnimeInfoWidget final : public QWidget {
		Q_OBJECT

	public:
		AnimeInfoWidget(QWidget* parent = nullptr);
		AnimeInfoWidget(const Anime::Anime& anime, QWidget* parent = nullptr);
		void SetAnime(const Anime::Anime& anime);

	private:
		std::shared_ptr<TextWidgets::OneLineSection> _title = nullptr;
		std::shared_ptr<TextWidgets::LabelledSection> _details = nullptr;
		std::shared_ptr<TextWidgets::SelectableSection> _synopsis = nullptr;
};

#endif // __gui__widgets__anime_info_h
