#ifndef __window_h
#define __window_h
#include "core/config.h"
#include <QMainWindow>
#include <memory>

/* *could* be forward-declared, but this causes
   any file that #includes this to have to #include
   these as well due to unique_ptr */
#include <QWidget>
#include <QStackedWidget>
#include <QCloseEvent>
#include <QThread>
#include "gui/widgets/sidebar.h"

class QMenu;

Q_DECLARE_METATYPE(std::vector<std::string>);

class PlayingThread : public QThread {
		Q_OBJECT

	public:
		PlayingThread(QObject* object = nullptr) : QThread(object) {}

	private:
		void run() override;

	signals:
		void Done(const std::vector<std::string>& files);
};

class MainWindow final : public QMainWindow {
		Q_OBJECT

	public:
		enum class Pages {
			NOW_PLAYING,

			ANIME_LIST,
			HISTORY,
			STATISTICS,

			SEARCH,
			SEASONS,
			TORRENTS
		};

		MainWindow(QWidget* parent = nullptr);
		void SetActivePage(QWidget* page);
		void CreateBars();
		void AddMainWidgets();
		void RetranslateUI();
		void UpdateFolderMenu();
		void AsyncSynchronize(QAction* action, QStackedWidget* stack);
		void changeEvent(QEvent* event) override;
		void showEvent(QShowEvent* event) override;
		void closeEvent(QCloseEvent* event) override;

	private:
		std::unique_ptr<QWidget> main_widget = nullptr;
		std::unique_ptr<QStackedWidget> stack = nullptr;
		std::unique_ptr<SideBar> sidebar = nullptr;

		std::unique_ptr<PlayingThread> thread = nullptr;

		QMenu* folder_menu = nullptr;
};

#endif // __window_h
