#ifndef MINORI_GUI_PAGES_STATISTICS_H_
#define MINORI_GUI_PAGES_STATISTICS_H_

#include <QFrame>
#include <QWidget>

#include "gui/widgets/graph.h"
#include "gui/widgets/text.h"

class StatisticsPage final : public QFrame {
	Q_OBJECT

public:
	StatisticsPage(QWidget* parent = nullptr);
	void UpdateStatistics();

protected:
	void showEvent(QShowEvent*) override;

private:
	TextWidgets::LabelledSection _anime_list;
	TextWidgets::LabelledSection _application;

	Graph<int> _score_distribution_graph;
};

#endif // MINORI_GUI_PAGES_STATISTICS_H_