#include "track/media.h"
#include "track/constants.h"
#include "animia.h"
#include "anitomy/anitomy.h"
#include "core/filesystem.h"
#include "core/strings.h"
#include "core/session.h"
#include <string>
#include <unordered_map>
#include <vector>
#include <iostream>
#include <QFile>
#include <QTextStream>

namespace Track {
namespace Media {

static bool GetCurrentlyPlayingResults(std::vector<animia::Result>& results) {
	std::vector<animia::Player> players;

	{
		QFile f(":/players.anisthesia");
		if (!f.exists())
			return false;

		f.open(QFile::ReadOnly | QFile::Text);
		QTextStream ts(&f);

		if (!animia::ParsePlayersData(Strings::ToUtf8String(ts.readAll()), players))
			return false;
	}

	if (!animia::GetResults(players, results))
		return false;

	return true;
}

/* meh */
bool GetCurrentlyPlaying(std::vector<std::string>& vec) {
	std::vector<animia::Result> results;

	if (!GetCurrentlyPlayingResults(results))
		return false;

	bool success = false;

	for (const auto& result : results) {
		for (const auto& media : result.media) {
			for (const auto& info : media.information) {
				vec.push_back(info.value);
				success |= true;
			}
		}
	}

	return success;
}

std::unordered_map<std::string, std::string> GetMapFromElements(const anitomy::Elements& elements) {
	/* there are way more than this in anitomy, but we only need basic information
	   I also just prefer using maps than using the ".get()" stuff which is why I'm doing this */
	std::unordered_map<std::string, std::string> ret;

	ret["title"] = Strings::ToUtf8String(elements.get(anitomy::kElementAnimeTitle));
	ret["filename"] = Strings::ToUtf8String(elements.get(anitomy::kElementFileName));
	ret["language"] = Strings::ToUtf8String(elements.get(anitomy::kElementLanguage));
	ret["group"] = Strings::ToUtf8String(elements.get(anitomy::kElementReleaseGroup));
	ret["episode"] = Strings::ToUtf8String(elements.get(anitomy::kElementEpisodeNumber));
	ret["resolution"] = Strings::ToUtf8String(elements.get(anitomy::kElementVideoResolution));

	return ret;
}

std::unordered_map<std::string, std::string> GetFileElements(const std::string& basename) {
	anitomy::Anitomy anitomy;
	anitomy.Parse(Strings::ToWstring(basename));

	return GetMapFromElements(anitomy.elements());
}

std::unordered_map<std::string, std::string> GetFileElements(const std::filesystem::path& path) {
	anitomy::Anitomy anitomy;
	anitomy.Parse(path.filename().wstring());

	return GetMapFromElements(anitomy.elements());
}

} // namespace Media
} // namespace Track
