#include "core/anime.h"
#include "core/session.h"
#include "core/strings.h"
#include "gui/dialog/settings.h"
#include "services/anilist.h"
#include <QComboBox>
#include <QGroupBox>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QSizePolicy>
#include <QVBoxLayout>

QWidget* SettingsPageServices::CreateMainPage() {
	QWidget* result = new QWidget(this);
	result->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QVBoxLayout* full_layout = new QVBoxLayout(result);

	{
		QGroupBox* sync_group_box = new QGroupBox(tr("Synchronization"), result);
		sync_group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

		QVBoxLayout* sync_layout = new QVBoxLayout(sync_group_box);

		{
			QLabel* sync_combo_box_label = new QLabel(tr("Active service and metadata provider:"), sync_group_box);
			sync_layout->addWidget(sync_combo_box_label);
		}

		{
			QComboBox* sync_combo_box = new QComboBox(sync_group_box);
			sync_combo_box->addItem(tr("AniList"));
			connect(sync_combo_box, QOverload<int>::of(&QComboBox::currentIndexChanged), this,
			        [this](int index) { service = static_cast<Anime::Services>(index + 1); });
			sync_combo_box->setCurrentIndex(static_cast<int>(service) - 1);
			sync_layout->addWidget(sync_combo_box);
		}

		{
			QLabel* sync_note_label =
			    new QLabel(tr("Note: Minori is unable to synchronize multiple services at the same time."), sync_group_box);
			sync_layout->addWidget(sync_note_label);
		}

		full_layout->addWidget(sync_group_box);
	}
	
	full_layout->setSpacing(10);
	full_layout->addStretch();

	return result;
}

QWidget* SettingsPageServices::CreateAniListPage() {
	QWidget* result = new QWidget(this);
	result->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Maximum);

	QVBoxLayout* full_layout = new QVBoxLayout(result);

	{
		/* Account */
		QGroupBox* group_box = new QGroupBox(tr("Account"), result);
		group_box->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

		QVBoxLayout* layout = new QVBoxLayout(group_box);

		{
			QLabel* username_entry_label = new QLabel(tr("Username: (not your email address)"), group_box);
			layout->addWidget(username_entry_label);
		}

		{
			/* Authorization */
			QWidget* auth_widget = new QWidget(group_box);
			QHBoxLayout* auth_layout = new QHBoxLayout(auth_widget);

			{
				/* Username: this literally never gets used btw */
				QLineEdit* username_entry = new QLineEdit(username, auth_widget);
				connect(username_entry, &QLineEdit::editingFinished, this,
				        [this, username_entry] { username = username_entry->text(); });
				auth_layout->addWidget(username_entry);
			}

			{
				/* The actual auth button */
				QPushButton* auth_button = new QPushButton(auth_widget);
				connect(auth_button, &QPushButton::clicked, this, [] { Services::AniList::AuthorizeUser(); });
				auth_button->setText(session.config.anilist.auth_token.empty() ? tr("Authorize...") : tr("Re-authorize..."));
				auth_layout->addWidget(auth_button);
			}

			layout->addWidget(auth_widget);
		}

		{
			/* Note on creating new accounts... */
			QLabel* note_label = new QLabel(tr("<a href=\"http://anilist.co/\">Create a new AniList account</a>"), group_box);
			note_label->setTextFormat(Qt::RichText);
			note_label->setTextInteractionFlags(Qt::TextBrowserInteraction);
			note_label->setOpenExternalLinks(true);
			layout->addWidget(note_label);
		}
		
		full_layout->addWidget(group_box);
	}

	full_layout->setSpacing(10);
	full_layout->addStretch();
	return result;
}

void SettingsPageServices::SaveInfo() {
	// see services/anilist.cc for why this is commented out
	// session.config.anilist.username = Strings::ToUtf8String(username);
	session.config.service = service;
}

SettingsPageServices::SettingsPageServices(QWidget* parent) : SettingsPage(parent, tr("Services")) {
	// username = QString::fromUtf8(session.config.anilist.username.c_str());
	service = session.config.service;
	AddTab(CreateMainPage(), tr("Main"));
	AddTab(CreateAniListPage(), tr("AniList"));
}
