#include "core/session.h"
#include "core/strings.h"
#include "gui/dialog/settings.h"
#include "track/types.h"
#include <QListWidget>
#include <QListWidgetItem>
#include <QGroupBox>
#include <QLabel>
#include <QSizePolicy>
#include <QVBoxLayout>
#include <algorithm>

Q_DECLARE_METATYPE(Track::Types::MediaPlayer);

QWidget* SettingsPageRecognition::CreatePlayersWidget() {
	QWidget* result = new QWidget(this);
	result->setAutoFillBackground(true);
	result->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

	QVBoxLayout* full_layout = new QVBoxLayout(result);

	{
		/* URLs */
		QGroupBox* group = new QGroupBox(tr("URLs"), result);
		group->setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Maximum);

		QVBoxLayout* group_layout = new QVBoxLayout(group);

		{
			/* Feed link */
			QWidget* widget = new QWidget(group);
			QVBoxLayout* widget_layout = new QVBoxLayout(widget);

			{
				QLabel* label = new QLabel(tr("Allowed media players:"), widget);
				widget_layout->addWidget(label);
			}

			{
				QListWidget* listwidget = new QListWidget(widget);
				for (const auto& player : session.recognition.players) {
					QListWidgetItem* item = new QListWidgetItem(listwidget);
					item->setCheckState(player.GetEnabled() ? Qt::Checked : Qt::Unchecked);
					item->setText(Strings::ToQString(player.GetName() + " (" + player.GetExecutable() + ")"));
					{
						QVariant v(QVariant::fromValue(player));
						item->setData(Qt::UserRole, v);
					}
				}
				widget_layout->addWidget(listwidget);
			}

			group_layout->addWidget(widget);
		}

		full_layout->addWidget(group);
	}

	full_layout->setSpacing(10);
	full_layout->addStretch();

	return result;
}

void SettingsPageRecognition::SaveInfo() {
}

SettingsPageRecognition::SettingsPageRecognition(QWidget* parent) : SettingsPage(parent, tr("Recognition")) {
	AddTab(CreatePlayersWidget(), tr("Players"));
}
