#ifndef MINORI_CORE_INI_H_
#define MINORI_CORE_INI_H_

#define MINI_CASE_SENSITIVE
#include "core/strings.h"
#include "mini/ini.h"
#include <string>

namespace INI {

std::string GetIniString(const mINI::INIStructure& ini, const std::string& section, const std::string& key, const std::string& def);
bool GetIniBool(const mINI::INIStructure& ini, const std::string& section, const std::string& key, bool def);

template<typename T>
T GetIniInteger(const mINI::INIStructure& ini, const std::string& section, const std::string& key, T def) {
	return Strings::ToInt<T>(GetIniString(ini, section, key, ""), def);
}

} // namespace INI

#endif
