/*
 * Copyright (C) 2016 The Qt Company Ltd.
 * Contact: https://www.qt.io/licensing/
 *
 * This file is part of the QtCore module of the Qt Toolkit.
 *
 * "Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in
 *     the documentation and/or other materials provided with the
 *     distribution.
 *   * Neither the name of The Qt Company Ltd nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
 */

#include "gui/widgets/elided_label.h"

#include <QPainter>
#include <QSizePolicy>
#include <QTextLayout>

ElidedLabel::ElidedLabel(const QString& text, QWidget* parent) : QFrame(parent), content(text) {
	setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Preferred);
}

void ElidedLabel::SetText(const QString& text) {
	content = text;
	update();
}

void ElidedLabel::paintEvent(QPaintEvent* event) {
	QFrame::paintEvent(event);

	QPainter painter(this);
	QFontMetrics metrics = painter.fontMetrics();

	const int line_spacing = metrics.lineSpacing();
	int y = 0;

	QTextLayout text_layout(content, painter.font());
	text_layout.beginLayout();
	for (;;) {
		QTextLine line = text_layout.createLine();
		if (!line.isValid())
			break;

		line.setLineWidth(width());

		if (height() >= y + (2 * line_spacing)) {
			line.draw(&painter, QPoint(0, y));
			y += line_spacing;
		} else {
			QString last_line = content.mid(line.textStart());
			QString elided_last_line = metrics.elidedText(last_line, Qt::ElideRight, width());
			painter.drawText(QPoint(0, y + metrics.ascent()), elided_last_line);
			line = text_layout.createLine();
			break;
		}
	}
	text_layout.endLayout();
}
