#ifndef __animia__animia_h
#define __animia__animia_h

#include "animia/media.h"
#include "animia/player.h"
#include "animia/types.h"

namespace animia {

struct Process {
	internal::pid_t pid = 0;
	std::string name;
};

struct Window {
	unsigned int id = 0;
	std::string class_name;
	std::string text; // title bar text
};

struct Result {
	Player player;
	Process process;
	Window window; // unused with file descriptors
	std::vector<Media> media;
};

bool GetResults(const std::vector<Player>& players, std::vector<Result>& results);

} // namespace Animia

#endif // __animia__animia_h
