#include "gui/widgets/anime_info.h"
#include "core/anime.h"
#include "core/strings.h"
#include "gui/translate/anime.h"
#include "gui/widgets/text.h"
#include <QHBoxLayout>
#include <QTextStream>

AnimeInfoWidget::AnimeInfoWidget(QWidget* parent) : QWidget(parent) {
	QVBoxLayout* layout = new QVBoxLayout(this);

	_title.reset(new TextWidgets::OneLineSection(tr("Alternative titles"), "", this));
	layout->addWidget(_title.get());

	_details.reset(new TextWidgets::LabelledSection(tr("Details"), tr("Type:\nEpisodes:\nStatus:\nSeason:\nGenres:\nScore:"), "", this));
	layout->addWidget(_details.get());

	_synopsis.reset(new TextWidgets::SelectableSection(tr("Synopsis"), "", this));
	_synopsis->GetParagraph()->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding);
	layout->addWidget(_synopsis.get());
}

AnimeInfoWidget::AnimeInfoWidget(const Anime::Anime& anime, QWidget* parent) : AnimeInfoWidget(parent) {
	SetAnime(anime);
}

void AnimeInfoWidget::SetAnime(const Anime::Anime& anime) {
	/* alt titles */
	_title->GetLine()->SetText(Strings::ToQString(Strings::Implode(anime.GetTitleSynonyms(), ", ")));

	/* details */
	QString details_data;
	QTextStream details_data_s(&details_data);
	/* we have to convert ALL of these strings to
	 * QString because QTextStream sucks and assumes
	 * Latin1 (on Windows?)
	*/
	details_data_s << Strings::ToQString(Translate::ToLocalString(anime.GetFormat())) << "\n"
	               << anime.GetEpisodes() << "\n"
	               << Strings::ToQString(Translate::ToLocalString(anime.GetUserStatus())) << "\n"
	               << Strings::ToQString(Translate::ToLocalString(anime.GetSeason())) << " "
	                   << anime.GetAirDate().GetYear().value_or(2000) << "\n"
	               << Strings::ToQString(Strings::Implode(anime.GetGenres(), ", ")) << "\n"
	               << anime.GetAudienceScore() << "%";
	_details->GetParagraph()->SetText(details_data);

	_synopsis->GetParagraph()->SetText(Strings::ToQString(anime.GetSynopsis()));

	updateGeometry();
}

#include "gui/widgets/moc_anime_info.cpp"
