#ifndef __animia__animia__util__osx_h
#define __animia__animia__util__osx_h

#include "animia/types.h"
#include <string>
#include <cstdint>

#ifdef HAVE_COREFOUNDATION
#include <CoreFoundation/CoreFoundation.h>
#endif

namespace animia::internal::osx::util {

#ifdef HAVE_COREFOUNDATION

template<typename T>
bool GetCFNumber(CFNumberRef num, T& result) {
	if (!num)
		return false;

	int64_t res;
	if (!CFNumberGetValue(num, static_cast<CFNumberType>(4), &res))
		return false;

	result = static_cast<T>(res);
	return true;
}

bool StringFromCFString(CFStringRef string, std::string& result);

#endif // HAVE_COREFOUNDATION

bool GetProcessName(pid_t pid, std::string& result);

}

#endif // __animia__animia__util__osx_h
